﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.WebUI.Admin.Helpers;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Brand
{
    public partial class Brands : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
           WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindProductBrandList(string.Empty);
            }
        }

        private void BindProductBrandList(string searchWord)
        {
            List<ProductBrand> pbList = ProductBrandBL.GetList(Guid.Empty, searchWord);
            pbList = (from pb in pbList
                      orderby pb.BrandName ascending
                      where pb.IsActive == true
                      select pb).ToList<ProductBrand>();
            grdProductBrand.DataSource = pbList;//.OrderBy(reg => reg.SequenceNo);
            grdProductBrand.DataBind();

            if (pbList.Count == 0)
                WebUtilities.ShowMessage(this, "No Product Brand found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindProductBrandList(string.Empty);
            Master.ExportToExcel<Entities.ProductBrand>(grdProductBrand, "BrandReport");
        }

        protected void grdProductBrand_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdProductBrand.PageIndex = e.NewPageIndex;
            BindProductBrandList(txtSearch.Text.Trim());
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtSearch.Text.Trim().Length == 0)
            {
                WebUtilities.ShowMessage(this, "Please enter the search word");
                return;
            }
            BindProductBrandList(txtSearch.Text.Trim());
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindProductBrandList(string.Empty);
        }
    }
}